IF NOT OBJECT_ID('P_RC_CLI_FIDELI_PONTOS_EXPIRA_POR_TEMPO') IS NULL
	BEGIN
		DROP PROCEDURE P_RC_CLI_FIDELI_PONTOS_EXPIRA_POR_TEMPO
	END

GO

CREATE PROCEDURE P_RC_CLI_FIDELI_PONTOS_EXPIRA_POR_TEMPO
AS
BEGIN 	
	SET NOCOUNT  ON ;

	BEGIN TRY

		DECLARE @RS_CD_EMP			INT 
		DECLARE @RS_CD_CLI			INT							
		DECLARE @RS_VLR_EXPIRAR		MONEY 
		DECLARE @RS_CD_CTR_PONTOS	INT
		DECLARE @RS_QTDE_PONTOS		MONEY 
		DECLARE @VLR_DEB			MONEY
		DECLARE @CD_CTR_PONTOS_DEB	INT  
		DECLARE @CD_MT_PONTO		INT 
		DECLARE @FLAG_MESES_EXPIRA_PONTOS_POR_TEMPO INT	
		DECLARE @DT_EXPIRA DATE;
			
		
		SET @FLAG_MESES_EXPIRA_PONTOS_POR_TEMPO = (SELECT ABS(DBO.UFD_BUSCA_PARAM_SISTEMA(1,'FLAG_MESES_EXPIRA_PONTOS_POR_TEMPO',0,0)))        
		SET @FLAG_MESES_EXPIRA_PONTOS_POR_TEMPO = (@FLAG_MESES_EXPIRA_PONTOS_POR_TEMPO * -1)
		
		SET  @DT_EXPIRA= DATEADD(MONTH, @FLAG_MESES_EXPIRA_PONTOS_POR_TEMPO, GETDATE());

		--Verificando se existe regra para expiracao de pontos por tempo sem compra, caso nao exista sai da procedure.
		IF @FLAG_MESES_EXPIRA_PONTOS_POR_TEMPO = 0 
			BEGIN
				RETURN 
			END
			
		--CODIGO DO MOTIVO DE EXPIRACAO DE PONTOS
		SET @CD_MT_PONTO = isnull( (SELECT CD_MT_PONTO FROM RC_MOTIVO_PONTO WHERE CD_ACAO_MT_PONTO = 17),0);

		if @CD_MT_PONTO =0
		begin
			Print 'Codigo de motivo de expiracao de pontos nao configurado.'
			return;
		end
		/************************************************************************************************************************************/
		--
		/************************************************************************************************************************************/

		SELECT 
			C.CD_EMP, 
			C.CD_CLI 
			INTO #RS_CLI
		FROM 
			RC_CLI C 
		WHERE C.QTDE_PONTOS > 0
			  AND C.STS_CLI = 0
			  AND C.TP_CONS_FINAL <> 1 
			  AND C.CONS_FINAL <> 1 
			  AND C.QTDE_PONTOS >  ISNULL((SELECT SUM(CRED.QTDE_PONTOS) 
										   FROM RC_CLI_FIDELI_PONTOS_CREDITO CRED 
										   WHERE CRED.CD_EMP 		= C.CD_EMP
												 AND CRED.CD_CLI 	= C.CD_CLI
												 AND CONVERT(VARCHAR(10),CRED.DT_CAD,112) >= @DT_EXPIRA),0);
			
		/************************************************************************************************************************************/
		--
		/************************************************************************************************************************************/

		SELECT 
			CRED.CD_EMP, 
			CRED.CD_CLI, 
			SUM(CRED.QTDE_PONTOS) AS VLR_CRED 
			INTO #RS_CREDITO
		FROM 
			RC_CLI_FIDELI_PONTOS_CREDITO CRED
			INNER JOIN #RS_CLI CLI ON	
				CRED.CD_EMP 	= CLI.CD_EMP
				AND CRED.CD_CLI = CLI.CD_CLI
		WHERE 
			CONVERT(VARCHAR(10),CRED.DT_CAD,112) < @DT_EXPIRA
		GROUP BY CRED.CD_EMP, CRED.CD_CLI;
		
		DROP TABLE #RS_CLI;
		/************************************************************************************************************************************/
		--
		/************************************************************************************************************************************/
		SELECT 
			DEB.CD_EMP, 
			DEB.CD_CLI, 
			SUM(DEB.QTDE_PONTOS) AS VLR_DEB 
			INTO #RS_DEBITO
		FROM RC_CLI_FIDELI_PONTOS_DEBITO DEB
		WHERE 
			EXISTS (SELECT CD_EMP 
					FROM #RS_CREDITO RS 
					WHERE RS.CD_EMP		= DEB.CD_EMP
						  AND RS.CD_CLI = DEB.CD_CLI)
		GROUP BY DEB.CD_EMP, DEB.CD_CLI;
		
		/************************************************************************************************************************************/
		--
		/************************************************************************************************************************************/
		SELECT 
			CRED.CD_EMP, 
			CRED.CD_CLI, 
			(CRED.VLR_CRED - ISNULL(DEB.VLR_DEB,0)) AS VLR_EXPIRAR 
		INTO #RS_EXPIRAR
		FROM 
			#RS_CREDITO CRED 
			LEFT JOIN #RS_DEBITO DEB ON 
				CRED.CD_EMP		= DEB.CD_EMP
				AND CRED.CD_CLI = DEB.CD_CLI
		WHERE 
			CRED.VLR_CRED > ISNULL(DEB.VLR_DEB,0);

		DROP TABLE #RS_CREDITO;
		DROP TABLE #RS_DEBITO;

		/************************************************************************************************************************************/
		--
		/************************************************************************************************************************************/

			DECLARE RS_RESULT CURSOR FOR
			SELECT 
				T.CD_EMP, 
				T.CD_CLI, 
				T.VLR_EXPIRAR
			FROM #RS_EXPIRAR T
			WHERE NOT EXISTS (SELECT 
					1 
			   FROM 
					LGPD_LOG_PROCESSAMENTO lgpd
				WHERE
					lgpd.CD_PESSOA = T.CD_CLI
					AND lgpd.TP_PROC = 0);

			--Abrindo cursor
			OPEN RS_RESULT 
			--Atribuindo valores do select nas variáveis
			FETCH NEXT FROM RS_RESULT INTO  @RS_CD_EMP, @RS_CD_CLI,@RS_VLR_EXPIRAR;
											
			--Iniciando laço
			WHILE @@FETCH_STATUS = 0
				BEGIN			
					
					DECLARE RS_CRED_EXP CURSOR FOR
						
						SELECT 
							CRED.CD_CTR_PONTOS, 
							CRED.QTDE_PONTOS
						FROM 
							RC_CLI_FIDELI_PONTOS_CREDITO CRED					
						WHERE 
							CONVERT(VARCHAR(10),CRED.DT_CAD,112) < @DT_EXPIRA	
							AND CRED.CD_EMP 		= @RS_CD_EMP
							AND CRED.CD_CLI 		= @RS_CD_CLI
							AND CRED.QTDE_PONTOS 	> 0
						ORDER BY CRED.DT_CAD DESC;
					
						OPEN RS_CRED_EXP
						--Atribuindo valores do select nas variáveis
						FETCH NEXT FROM RS_CRED_EXP INTO  	@RS_CD_CTR_PONTOS, @RS_QTDE_PONTOS;
														
						--Iniciando laço
						WHILE @@FETCH_STATUS = 0 AND @RS_VLR_EXPIRAR > 0
							BEGIN						
								IF @RS_VLR_EXPIRAR > @RS_QTDE_PONTOS
									BEGIN
										SET @VLR_DEB 			= @RS_QTDE_PONTOS
										SET @RS_VLR_EXPIRAR 	= (@RS_VLR_EXPIRAR - @VLR_DEB)
									END
								ELSE	
									BEGIN
										SET @VLR_DEB 		= @RS_VLR_EXPIRAR
										SET @RS_VLR_EXPIRAR	= 0
									END
														 
								INSERT INTO RC_CLI_FIDELI_PONTOS_DEBITO  (CD_EMP, CD_CLI, QTDE_PONTOS, DT_CAD, CD_USU, CD_MT_PONTO, APP_NAME) 
									VALUES (@RS_CD_EMP, @RS_CD_CLI, @VLR_DEB, CONVERT(VARCHAR(10), GETDATE(), 101), 1, @CD_MT_PONTO, 'P_RC_CLI_FIDELI_PONTOS_EXPIRA_POR_TEMPO')
								
								SET @CD_CTR_PONTOS_DEB = (SELECT IDENT_CURRENT('RC_CLI_FIDELI_PONTOS_DEBITO'))
								
								INSERT INTO RC_CLI_FIDELI_PONTOS_DEBITO_RC_CLI_FIDELI_PONTOS_CREDITO (CD_CTR_PONTOS_CRED, CD_CTR_PONTOS_DEB) 
									VALUES (@RS_CD_CTR_PONTOS, @CD_CTR_PONTOS_DEB)
								
								--Atribuindo valores do select nas variáveis
								FETCH NEXT FROM RS_CRED_EXP INTO  	@RS_CD_CTR_PONTOS, @RS_QTDE_PONTOS							
							END
							
							CLOSE RS_CRED_EXP
							DEALLOCATE RS_CRED_EXP
										
					--Atribuindo valores do select nas variáveis
					FETCH NEXT FROM RS_RESULT INTO  @RS_CD_EMP,  @RS_CD_CLI,@RS_VLR_EXPIRAR;

				END

			CLOSE RS_RESULT
			DEALLOCATE RS_RESULT	
			
			DROP TABLE #RS_EXPIRAR;
		/************************************************************************************************************************************/
		--
		/************************************************************************************************************************************/
			
	END TRY
	BEGIN CATCH
		CLOSE RS_RESULT
		DEALLOCATE RS_RESULT	

		INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
			SELECT
				ERROR_NUMBER() AS numero,
				ERROR_SEVERITY() AS severidade,
				ERROR_STATE() AS estado,
				ERROR_PROCEDURE() AS rotina,
				ERROR_LINE() AS linha,
				ERROR_MESSAGE() AS mensagem,
				GETDATE() AS dtErro;	
	END CATCH			

END		

		
		 